%% MATLAB_380_FUN_WITH_MUSIC

% Objective: Have fun and Explore.

% This is to show you some applications of the FFT, and 
% how it can be applied. Explore the files provided, and
% try to create something fun. 

% You will need to run this script before running the other scripts.

%% Note Generation

% gets data from file
[cello_note_D3, sampleRate] = audioread('cello-196hz-lowpass.wav');
% For fun, try reading in a sample of a note played by 
% another instrument and get its FFT coefficients.


% keeps one second worth of the data
cello_note_D3 = cello_note_D3([2*sampleRate:3*sampleRate],1)';
% time array 
t = (0:1/sampleRate:1);

% plots the time version of the the note
figure(1);
plot(t,cello_note_D3);
xlabel('time (s)');
ylabel('amplitude');
title('original signal');

% plots the fft transform of the note
figure(2);
[f,a] = fft_plot(cello_note_D3,sampleRate);
xlabel('frequenzy (Hz)');
ylabel('amplitude or FFT coefficients');
title('original signal FFT plot');

% these coefficients were obtained from the FFT plot.
% Even though these coefficients were obtained from note
% D3, they will be used to create all the notes as shown below.
coe = [0.08782,0.02148,0.003238,0.05453,0.008,0.01953,...
    0.003791, 0.01122, 0.009583, 0.003443, 0.005912,...
    0.001418,0.001687, 0.003, 0.001681, 0.0004164, 0.0008027, 0.0003906 ];


% The table below associates various notes with its frequencies in Hz.
% The margin on the left show which octave the notes pertain to starting
% with the lowest octave.

% 	 C	      C#	  D       Eb	  E	      F	      F#	  G	      G#	  A	      Bb	  B
% 0	16.35	17.32	18.35	19.45	20.60	21.83	23.12	24.50	25.96	27.50	29.14	30.87
% 1	32.70	34.65	36.71	38.89	41.20	43.65	46.25	49.00	51.91	55.00	58.27	61.74
% 2	65.41	69.30	73.42	77.78	82.41	87.31	92.50	98.00	103.8	110.0	116.5	123.5
% 3	130.8	138.6	146.8	155.6	164.8	174.6	185.0	196.0	207.7	220.0	233.1	246.9
% 4	261.6	277.2	293.7	311.1	329.6	349.2	370.0	392.0	415.3	440.0	466.2	493.9
% 5	523.3	554.4	587.3	622.3	659.3	698.5	740.0	784.0	830.6	880.0	932.3	987.8
% 6	1047	1109	1175	1245	1319	1397	1480	1568	1661	1760	1865	1976
% 7	2093	2217	2349	2489	2637	2794	2960	3136	3322	3520	3729	3951
% 8	4186	4435	4699	4978	5274	5588	5920	6272	6645	7040	7459	7902


% Below I have created 2 octaves of notes using the harmonic coefficients
% obtained from the sampled data.

% frequency harmonics of cello
A2_F = 110;
Bb2_F = 116.5 ;
B2_F = 123.5;
C3_F = 130.8;
CS3_F = 138.6;
D3_F = 146.8;
Eb3_F = 155.6;
E3_F = 164.8;
F3_F =174.6;
FS3_F = 185;
G3_F = 194;
GS3_F = 207.7;
A3_F = 220;
Bb3_F = 233.1 ;
B3_F = 246.9;
C4_F = 261.6;
CS4_F = 277.2;
D4_F = 293.7;
Eb4_F = 311.1;
E4_F = 329.6;
F4_F =349.2;
FS4_F = 370;
G4_F = 392;
GS4_F = 415.3;




% allocation of memory
A2 = zeros(1,length(t));
Bb2 =zeros(1,length(t));
B2 = zeros(1,length(t));
C3 = zeros(1,length(t));
CS3 = zeros(1,length(t));
D3 = zeros(1,length(t));
Eb3 = zeros(1,length(t));
E3 = zeros(1,length(t));
F3 = zeros(1,length(t));
FS3 = zeros(1,length(t));
G3 = zeros(1,length(t));
GS3 = zeros(1,length(t));
A3 = zeros(1,length(t));
Bb3 = zeros(1,length(t));
B3 = zeros(1,length(t));
C4 = zeros(1,length(t));
CS4 = zeros(1,length(t));
D4 = zeros(1,length(t));
Eb4 = zeros(1,length(t));
E4 = zeros(1,length(t));
F4 = zeros(1,length(t));
FS4 = zeros(1,length(t));
G4 = zeros(1,length(t));
GS4 = zeros(1,length(t));


% the for loop adds each harmonic together using the coefficients
% obtained above. The notes have a duration of 1 second.
for m = 1:length(coe)
A2 = A2 + coe(m)*cos(2*pi*m*A2_F*t);
Bb2 = Bb2 + coe(m)*cos(2*pi*m*Bb2_F*t);
B2 = B2 + coe(m)*cos(2*pi*m*B2_F*t);
C3 = C3 + coe(m)*cos(2*pi*m*C3_F*t);
CS3 = CS3 + coe(m)*cos(2*pi*m*CS3_F*t);
D3 = D3 + coe(m)*cos(2*pi*m*D3_F*t);
Eb3 = Eb3 + coe(m)*cos(2*pi*m*Eb3_F*t);
E3 = E3 + coe(m)*cos(2*pi*m*E3_F*t);
F3 = F3 + coe(m)*cos(2*pi*m*F3_F*t);
FS3 = FS3+ coe(m)*cos(2*pi*m*FS3_F*t);
G3 = G3 + coe(m)*cos(2*pi*m*G3_F*t);
GS3 = GS3 + coe(m)*cos(2*pi*m*GS3_F*t);
A3 = A3 + coe(m)*cos(2*pi*m*A3_F*t);
Bb3 = Bb3 + coe(m)*cos(2*pi*m*Bb3_F*t);
B3 = B3 + coe(m)*cos(2*pi*m*B3_F*t);
C4 = C4 + coe(m)*cos(2*pi*m*C4_F*t);
CS4 = CS4 +  coe(m)*cos(2*pi*m*CS4_F*t);
D4 = D4 + coe(m)*cos(2*pi*m*D4_F*t);
Eb4 = Eb4 +coe(m)*cos(2*pi*m*Eb4_F*t);
E4 = E4 + coe(m)*cos(2*pi*m*E4_F*t);
F4 = F4 + coe(m)*cos(2*pi*m*F4_F*t);
FS4 = FS4 + coe(m)*cos(2*pi*m*FS4_F*t);
G4 = G4 + coe(m)*cos(2*pi*m*G4_F*t);
GS4 = GS4 + coe(m)*cos(2*pi*m*GS4_F*t);
end

