function [f,A] = fft_plot(signal, sample_frequency)

% This function creates an fft plot. It shows only the positive side of the
% frequency spectrum

L = length(signal);     % Length of signal           
NFFT = 2^nextpow2(L); % Next power of 2 from length of y. Doing this will make the fft computation
% easier

% applies the fft
signal_FFT = fft(signal,NFFT)/L;

A = 2*abs(signal_FFT(1:NFFT/2+1));

% frequency vector
f = sample_frequency/2*linspace(0,1,NFFT/2+1);

% Plot single-sided amplitude spectrum.
plot(f,2*abs(signal_FFT(1:NFFT/2+1))) 



